//
//  $Id: WXKContactWindowController_Communication.m 109 2009-06-27 16:24:38Z fujidana $
//  Copyright 2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKContactWindowController.h"
#import "WXKPhone.h"
#import "WXKProgressWindowController.h"


@implementation WXKContactWindowController (Communication)

#pragma mark communication

- (BOOL)receiveWithPassword:(NSString *)password progressController:(WXKProgressWindowController *)progress error:(NSError **)errorPtr
{
	// Begin to communicate with Kyopon.
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	NSArray *dataArray;
	
	// Receive data from Kyopon.
	if ([phone openConnectionWithPassword:password progress:progress error:errorPtr] == NO) return NO;
	if ((dataArray = [phone arrayOfDataType:WXKPhoneContactDataType error:errorPtr]) == nil) return NO;
	[phone closeConnection];
	
	[[[self containerArrayController] tableView] setNeedsDisplay:NO];
	[[[self contentArrayController] tableView] setNeedsDisplay:NO];
	
	// If successfully received data...
	
	// At first, remove all existing bookmarks
	NSManagedObjectContext *context    = [self managedObjectContext];
	NSEnumerator           *enumerator = [[[self contentArrayController] allObjects] objectEnumerator];
	NSManagedObject        *object;
	while (object = [enumerator nextObject])
	{
		[context deleteObject:object];
	}
	[context processPendingChanges];
	
	
	// Then, parse received data.
//	NSArray         *allFolders = [[self containerArrayController] allObjects];
//	NSManagedObject *indexer = [(FJNIndexedContentArrayController *)[self contentArrayController] indexer];
	int i;
	for (i = 0; i < [dataArray count]; i++)
	{
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		
		NSData *data = [dataArray objectAtIndex:i];
		
		//
		NSString *filename = [NSString stringWithFormat:@"address_%03d.txt", i];
		NSString *filepath = [NSHomeDirectory() stringByAppendingPathComponent:filename];
		[data writeToFile:filepath atomically:YES];
		//
		
		// finish reading all fields.
		id address = [NSEntityDescription insertNewObjectForEntityForName:@"Contact"
												   inManagedObjectContext:context];
		
//			// set bookmark attributes to read fields.
//			id bookmark = [NSEntityDescription insertNewObjectForEntityForName:@"Bookmark"
//														inManagedObjectContext:context];
//			
//			NSNumber *index = [NSNumber numberWithInt:[stringFields[2] intValue]];
//			
//			id folder = nil;
//			int folderIndex = [stringFields[3] intValue];
//			if ([allFolders count] > folderIndex) folder = [allFolders objectAtIndex:folderIndex];
//			
//			[bookmark setValue:[NSNumber numberWithInt:i] forKey:@"order"];
//			[bookmark setValue:stringFields[0] forKey:@"title"];
//			[bookmark setValue:stringFields[1] forKey:@"url"];
//			[bookmark setValue:index forKey:@"index"];
//			[bookmark setValue:folder forKey:@"container"];
//			[bookmark setValue:indexer forKey:@"indexer"];
//		}
		[pool release];
	}
	
	[[[self containerArrayController] tableView] setNeedsDisplay:YES];
	[[[self contentArrayController] tableView] setNeedsDisplay:YES];
	
	return YES;
}

- (BOOL)sendWithPassword:(NSString *)password progressController:(WXKProgressWindowController *)progress error:(NSError **)errorPtr
{
	NSArray         *addresses  = [[self contentArrayController] allObjects];
	NSEnumerator    *enumerator = [addresses objectEnumerator];
	NSMutableArray  *dataArray  = [NSMutableArray arrayWithCapacity:[addresses count]];
	NSManagedObject *address;
	
	while (address = [enumerator nextObject])
	{
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		
//		[dataArray addObject:];
		
		[pool release];
	}
	
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	
	if ([phone openConnectionWithPassword:password progress:progress error:errorPtr] == NO) return NO;
	if ([phone setArray:dataArray ofDataType:WXKPhoneContactDataType error:errorPtr] == NO) return NO;
	[phone closeConnection];
	
	return YES;
}

@end
